/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigActionCommand;
import filenet.vw.toolkit.admin.VWConfigContextMenu;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.security.VWParticipantLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;

public class VWConfigSecurityPane
extends VWUsersAndGroupsPanel
implements ActionListener,
IVWListUpdateListener {
    public static final int ACCESS_NONE = 0;
    public static final int ACCESS_READ = 1;
    public static final int ACCESS_WRITE = 2;
    public static final int ACCESS_CREATE = 4;
    public static final int ACCESS_INVALID = 16;
    public static final int QUEUE_SEC = 1;
    public static final int ROSTER_SEC = 2;
    private static final ImageIcon ICON_USER = VWImageLoader.createImageIcon("user.gif");
    private static final ImageIcon ICON_GROUP = VWImageLoader.createImageIcon("group.gif");
    private static final ImageIcon ICON_INVALID = VWImageLoader.createImageIcon("unknode16.gif");
    protected VWSessionInfo m_sessionInfo = null;
    protected int m_secType = -1;
    protected ConfigAccessSecurity[] m_availAccessList;
    protected ConfigAccessSecurity[] m_selectedAccessList;
    protected JCheckBox m_queryRightCheckBox;
    protected JCheckBox m_otherRightCheckBox;
    protected VWConfigContextMenu m_accessRightMenu;
    protected JLabel m_allUserPermissionLabel;
    private boolean m_bModified = false;

    public VWConfigSecurityPane(Container parentContainer, VWSessionInfo sessionInfo, VWParticipant[] readRight, VWParticipant[] otherRight, int secType) {
        super(parentContainer, sessionInfo.getSession());
        this.m_sessionInfo = sessionInfo;
        this.m_secType = secType;
        this.init(readRight, otherRight);
    }

    public boolean ValidateAccessList() {
        boolean bRet = true;
        String sInvalidUserName = null;
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ConfigAccessSecurity accessSecurity = (ConfigAccessSecurity)listModel.elementAt(i);
            if (accessSecurity.m_userAccessSecurity != 16 && accessSecurity.m_userAccessSecurity != 0) continue;
            sInvalidUserName = accessSecurity.getName();
            String errMsg = VWResource.SecurityListHasInvalidUser.toString("'" + sInvalidUserName + "'");
            JOptionPane.showMessageDialog(this.m_parentContainer, errMsg, null, 0, null);
            bRet = false;
        }
        return bRet;
    }

    public VWParticipant[] getAccessListPx(int accessPermission) {
        Vector<VWParticipant> list = new Vector<VWParticipant>();
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            ConfigAccessSecurity accessSecurity = (ConfigAccessSecurity)listModel.elementAt(i);
            if (accessSecurity.getType() == 3 || (accessSecurity.m_userAccessSecurity & accessPermission) != accessPermission) continue;
            list.addElement(accessSecurity.getVWParticipant());
        }
        if (list.size() == 0) {
            return null;
        }
        Object[] accessList = new VWParticipant[list.size()];
        list.copyInto(accessList);
        return accessList;
    }

    public VWParticipant[] getReadSecurityPx() {
        return this.getAccessListPx(1);
    }

    public VWParticipant[] getWriteSecurityPx() {
        return this.getAccessListPx(2);
    }

    public VWParticipant[] getCreateSecurityPx() {
        return this.getAccessListPx(4);
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void releaseResources() {
        int i;
        if (this.m_availAccessList != null) {
            for (i = 0; i < this.m_availAccessList.length; ++i) {
                this.m_availAccessList[i].releaseResources();
                this.m_availAccessList[i] = null;
            }
            this.m_availAccessList = null;
        }
        if (this.m_selectedAccessList != null) {
            for (i = 0; i < this.m_selectedAccessList.length; ++i) {
                this.m_selectedAccessList[i].releaseResources();
                this.m_selectedAccessList[i] = null;
            }
            this.m_selectedAccessList = null;
        }
        if (this.m_queryRightCheckBox != null) {
            this.m_queryRightCheckBox.removeAll();
            this.m_queryRightCheckBox = null;
        }
        if (this.m_otherRightCheckBox != null) {
            this.m_otherRightCheckBox.removeAll();
            this.m_otherRightCheckBox = null;
        }
        if (this.m_accessRightMenu != null) {
            this.m_accessRightMenu.releaseResources();
            this.m_accessRightMenu = null;
        }
        if (this.m_allUserPermissionLabel != null) {
            this.m_allUserPermissionLabel.removeAll();
            this.m_allUserPermissionLabel = null;
        }
        this.m_sessionInfo = null;
        super.releaseResources();
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (this.m_parentContainer != null) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
        }
        if (object == this.m_queryRightCheckBox || object == this.m_otherRightCheckBox) {
            if (this.m_queryRightCheckBox.isSelected() || this.m_otherRightCheckBox.isSelected()) {
                this.m_addAllButton.setEnabled(true);
                if (this.m_availableList.getSelectedIndex() != -1) {
                    this.m_addButton.setEnabled(true);
                } else {
                    this.m_addButton.setEnabled(false);
                }
            } else {
                this.m_addAllButton.setEnabled(false);
                this.m_addButton.setEnabled(false);
            }
        } else {
            String actionCMD = event.getActionCommand();
            if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SECURITY_Q) == 0) {
                this.modifySelectedUserList(1);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SECURITY_P) == 0) {
                this.modifySelectedUserList(2);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SECURITY_C) == 0) {
                this.modifySelectedUserList(4);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SECURITY_QP) == 0) {
                this.modifySelectedUserList(3);
            } else if (VWStringUtils.compare(actionCMD, VWConfigActionCommand.ACMD_SECURITY_QC) == 0) {
                this.modifySelectedUserList(5);
            } else {
                super.actionPerformed(event);
                if (object.equals(this.m_addAllButton) || object.equals(this.m_addButton) || object.equals(this.m_removeAllButton) || object.equals(this.m_removeButton)) {
                    this.m_bModified = true;
                }
            }
        }
        if (this.m_parentContainer != null) {
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        switch (nEventType) {
            case 1: 
            case 2: {
                this.checkAllUserPermission();
                break;
            }
            case 5: {
                break;
            }
        }
    }

    protected void addControls() {
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 3, 3);
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener(this);
            this.m_availableList.addMouseListener(new VWMouseAdapter(this));
            this.add((Component)this.createAvailableListPanel(this.m_availableList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_availableLabel, this.m_availableList);
            this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbCons.anchor = 10;
            gbCons.gridx = 1;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            gbCons.gridx = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.m_selectedList.addMouseListener(new SecurityPaneMouse());
            this.add((Component)this.createSelectedListPanel(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setLabelFor(this.m_selectedLabel, this.m_selectedList);
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWParticipant[] getParticipantArray(String[] userNames) {
        try {
            if (userNames != null && userNames.length > 0) {
                return this.m_vwSession.fetchParticipantsPx(null, userNames);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected void updateTheMainButtonsState() {
        super.updateTheMainButtonsState();
        boolean bEnable = false;
        if (this.m_availableList.getSelectedIndex() != -1 && (this.m_queryRightCheckBox.isSelected() || this.m_otherRightCheckBox.isSelected())) {
            bEnable = true;
        }
        this.m_addButton.setEnabled(bEnable);
    }

    protected void onAddItemsAction(Object[] items) {
        int accessSecurity = this.getDefaultAccessPermission();
        for (int i = 0; i < items.length; ++i) {
            ((ConfigAccessSecurity)items[i]).m_userAccessSecurity = accessSecurity;
        }
        super.onAddItemsAction(items);
    }

    protected Object[] onRemoveItemsAction(Object[] items) {
        for (int i = 0; i < items.length; ++i) {
            ((ConfigAccessSecurity)items[i]).m_userAccessSecurity = 0;
        }
        return items;
    }

    protected JPanel createAvailableListPanel(JList list) {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst = new GridBagConstraints();
            gbConst.anchor = 23;
            gbConst.fill = 2;
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.TypeAheadLabel));
            mainPanel.add((Component)label, gbConst);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_typeAheadName = new JTextField();
            this.m_typeAheadName.getDocument().addDocumentListener(this);
            this.m_typeAheadName.addKeyListener(this);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_typeAheadName, gbConst);
            VWAccessibilityHelper.setLabelFor(label, this.m_typeAheadName);
            this.m_typeAheadName.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.fill = 1;
            ++gbConst.gridy;
            gbConst.weighty = 1.0;
            mainPanel.add((Component)new JScrollPane(list), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createAddRemoveButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 10;
            gbConst.fill = 0;
            gbConst.gridx = 0;
            gbConst.gridy = -1;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setDisabledIcon(VWImageLoader.createImageIcon("addall_d.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setName("m_addAllButton_VWConfigSecurityPanel");
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, this, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                panel.add((Component)this.m_addAllButton, gbConst);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setDisabledIcon(VWImageLoader.createImageIcon("add_d.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setName("m_addButton_VWConfigSecurityPanel");
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_add, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)this.m_addButton, gbConst);
            this.m_removeButton = new JButton(filenet.vw.toolkit.utils.images.VWImageLoader.createImageIcon("remove.gif"));
            this.m_removeButton.setToolTipText(VWResource.s_remove);
            this.m_removeButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_removeButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_removeButton);
            panel.add((Component)this.m_removeButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, VWResource.s_remove, VWResource.s_remove);
            this.m_removeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (this.m_bShowMoveAllButtons) {
                this.m_removeAllButton = new JButton(filenet.vw.toolkit.utils.images.VWImageLoader.createImageIcon("removeall.gif"));
                this.m_removeAllButton.setToolTipText(VWResource.s_removeAll);
                this.m_removeAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_removeAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_removeAllButton);
                panel.add((Component)this.m_removeAllButton, gbConst);
                VWAccessibilityHelper.setAccessibility(this.m_removeAllButton, this, VWResource.s_removeAll, VWResource.s_removeAll);
                this.m_removeAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            gbConst.fill = 2;
            gbConst.insets = new Insets(60, 4, 4, 4);
            JLabel defaultRightsLabel = new JLabel(VWResource.s_label.toString(VWResource.DefaultRights));
            panel.add((Component)defaultRightsLabel, gbConst);
            gbConst.insets = new Insets(0, 0, 0, 0);
            VWAccessibilityHelper.setAccessibility(defaultRightsLabel, this, VWResource.DefaultRights, VWResource.DefaultRights);
            defaultRightsLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_queryRightCheckBox = new JCheckBox(VWResource.Query);
            this.m_queryRightCheckBox.addActionListener(this);
            panel.add((Component)this.m_queryRightCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_queryRightCheckBox, this, VWResource.Query, VWResource.Query);
            this.m_queryRightCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_otherRightCheckBox = new JCheckBox(VWResource.Process);
            this.m_otherRightCheckBox.addActionListener(this);
            panel.add((Component)this.m_otherRightCheckBox, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_otherRightCheckBox, this, VWResource.Process, VWResource.Process);
            this.m_otherRightCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    protected JPanel createSelectedListPanel(JList list) {
        JPanel mainPanel = null;
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.SelectedUsers));
            mainPanel.add((Component)label, "First");
            mainPanel.add((Component)new JScrollPane(list), "Center");
            this.m_allUserPermissionLabel = new JLabel();
            mainPanel.add((Component)this.m_allUserPermissionLabel, "Last");
            this.m_allUserPermissionLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            VWAccessibilityHelper.setAccessibility(mainPanel, this.m_allUserPermissionLabel, this.m_allUserPermissionLabel.getText(), this.m_allUserPermissionLabel.getText());
            VWAccessibilityHelper.setLabelFor(label, list);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(VWParticipant[] readRight, VWParticipant[] otherRight) {
        try {
            block5: {
                try {
                    if (this.m_parentContainer != null) {
                        this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    this.addListUpdateListener(this);
                    Object[] selectedItems = this.createSelectedAccessList(readRight, otherRight);
                    Object[] availItems = this.createAvailableAccessList((ConfigAccessSecurity[])selectedItems);
                    this.setListCellRenderer(new SecurityListCellRenderer());
                    super.initializeLists(availItems, selectedItems);
                    this.checkAllUserPermission();
                    this.m_accessRightMenu = this.m_secType == 2 ? new VWConfigContextMenu(this.m_sessionInfo, 22, this, null) : new VWConfigContextMenu(this.m_sessionInfo, 21, this, null);
                    this.m_queryRightCheckBox.setSelected(true);
                    this.m_otherRightCheckBox.setSelected(true);
                    if (this.m_secType != 2) break block5;
                    this.m_otherRightCheckBox.setText(VWResource.Create);
                    VWAccessibilityHelper.setAccessibility(this.m_otherRightCheckBox, this, VWResource.Create, VWResource.Create);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var6_7 = null;
                    if (this.m_parentContainer == null) return;
                    this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
            }
            Object var6_6 = null;
            if (this.m_parentContainer == null) return;
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (this.m_parentContainer == null) throw throwable;
            this.m_parentContainer.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
    }

    private void modifySelectedUserList(int authorization) {
        try {
            int[] indices = this.m_selectedList.getSelectedIndices();
            if (indices == null || indices.length <= 0) {
                return;
            }
            VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
            for (int i = 0; i < indices.length; ++i) {
                ConfigAccessSecurity aEle = (ConfigAccessSecurity)listModel.elementAt(indices[i]);
                if (aEle.m_userAccessSecurity == 16) continue;
                aEle.m_userAccessSecurity = authorization;
            }
            this.checkAllUserPermission();
            this.m_selectedList.updateUI();
            this.m_bIsModified = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private int searchList(String name, ConfigAccessSecurity[] selectedList, int startOffset) {
        if (selectedList == null || selectedList.length <= 0) {
            return -1;
        }
        try {
            for (int i = startOffset; i < selectedList.length; ++i) {
                if (VWStringUtils.compare(name, selectedList[i].getName()) != 0) continue;
                return i;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    protected ConfigAccessSecurity[] createAvailableAccessList(ConfigAccessSecurity[] selectedItems) {
        int selectedItemListIndex = 0;
        Vector<ConfigAccessSecurity> colAvailAccessList = new Vector<ConfigAccessSecurity>();
        ConfigAccessSecurity[] availAccessList = null;
        try {
            this.m_availableParticipants = VWCachedSecurityList.getUsersAndGroupsParticipant(this.m_vwSession);
            int listSz = this.m_availableParticipants.length;
            for (int i = 0; i < listSz; ++i) {
                String itemName = this.m_availableParticipants[i].getShortName();
                int idx = this.searchList(itemName, selectedItems, selectedItemListIndex);
                if (idx >= 0) {
                    selectedItemListIndex = idx + 1;
                    continue;
                }
                ConfigAccessSecurity aEle = new ConfigAccessSecurity(this.m_availableParticipants[i].getVWParticipant(), 0);
                colAvailAccessList.add(aEle);
            }
            availAccessList = colAvailAccessList.toArray(new ConfigAccessSecurity[0]);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return availAccessList;
    }

    private ConfigAccessSecurity[] createSelectedAccessList(VWParticipant[] readRight, VWParticipant[] otherRight) {
        int combinedListSize = 0;
        int readRightSize = 0;
        int otherRightSize = 0;
        int readRightIndex = 0;
        int otherRightIndex = 0;
        VWParticipant readRightItem = null;
        VWParticipant otherRightItem = null;
        ConfigAccessSecurity[] selectedAccessList = null;
        try {
            if (readRight != null && readRight.length > 0) {
                VWQubbleSort.sort(readRight);
            }
            if (otherRight != null && otherRight.length > 0) {
                VWQubbleSort.sort(otherRight);
            }
            int otherPermission = this.m_secType == 2 ? 4 : 2;
            if (otherRight == null || otherRight.length <= 0) {
                if (readRight != null && readRight.length > 0) {
                    int sz = readRight.length;
                    selectedAccessList = new ConfigAccessSecurity[sz];
                    for (int i = 0; i < sz; ++i) {
                        selectedAccessList[i] = new ConfigAccessSecurity(readRight[i], 1);
                    }
                }
                return selectedAccessList;
            }
            otherRightSize = otherRight.length;
            if (readRight == null || readRight.length <= 0) {
                if (otherRight != null && otherRight.length > 0) {
                    int sz = otherRight.length;
                    selectedAccessList = new ConfigAccessSecurity[sz];
                    for (int i = 0; i < sz; ++i) {
                        selectedAccessList[i] = new ConfigAccessSecurity(otherRight[i], otherPermission);
                    }
                }
                return selectedAccessList;
            }
            readRightSize = readRight.length;
            Vector<ConfigAccessSecurity> colSelectedAccessList = new Vector<ConfigAccessSecurity>();
            combinedListSize = readRightSize + otherRightSize;
            for (int i = 0; i < combinedListSize; ++i) {
                ConfigAccessSecurity aEle;
                if (readRightIndex >= readRightSize) {
                    if (otherRightIndex >= otherRightSize) continue;
                    ConfigAccessSecurity aEle2 = new ConfigAccessSecurity(otherRight[otherRightIndex], otherPermission);
                    colSelectedAccessList.add(aEle2);
                    ++otherRightIndex;
                    continue;
                }
                if (otherRightIndex >= otherRightSize) {
                    if (readRightIndex >= readRightSize) continue;
                    ConfigAccessSecurity aEle3 = new ConfigAccessSecurity(readRight[readRightIndex], 1);
                    colSelectedAccessList.add(aEle3);
                    ++readRightIndex;
                    continue;
                }
                readRightItem = readRight[readRightIndex];
                otherRightItem = otherRight[otherRightIndex];
                int cmpResult = VWStringUtils.compare(readRightItem.getParticipantName(), otherRightItem.getParticipantName());
                if (cmpResult == 0) {
                    aEle = new ConfigAccessSecurity(readRightItem, 1 | otherPermission);
                    colSelectedAccessList.add(aEle);
                    ++readRightIndex;
                    ++otherRightIndex;
                    continue;
                }
                if (cmpResult > 0) {
                    aEle = new ConfigAccessSecurity(otherRightItem, otherPermission);
                    colSelectedAccessList.add(aEle);
                    ++otherRightIndex;
                    continue;
                }
                aEle = new ConfigAccessSecurity(readRightItem, 1);
                colSelectedAccessList.add(aEle);
                ++readRightIndex;
            }
            selectedAccessList = colSelectedAccessList.toArray(new ConfigAccessSecurity[0]);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return selectedAccessList;
    }

    private int getDefaultAccessPermission() {
        int iAccess = 0;
        if (this.m_queryRightCheckBox.isSelected()) {
            iAccess |= 1;
        }
        if (this.m_otherRightCheckBox.isSelected()) {
            iAccess = this.m_secType == 2 ? (iAccess |= 4) : (iAccess |= 2);
        }
        return iAccess;
    }

    private void checkAllUserPermission() {
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        int dz = listModel.getSize();
        int sec = 0;
        for (int i = 0; i < dz; ++i) {
            ConfigAccessSecurity elem = (ConfigAccessSecurity)listModel.getElementAt(i);
            sec |= elem.m_userAccessSecurity;
        }
        int allUserPermission = this.m_secType == 2 ? 5 ^ sec : 3 ^ sec;
        String sPermission = this.getAccessPermissionString(allUserPermission);
        this.m_allUserPermissionLabel.setText(VWResource.s_label.toString(VWResource.AllUsers) + sPermission);
        VWAccessibilityHelper.setAccessibility(this.m_allUserPermissionLabel, null, this.m_allUserPermissionLabel.getText(), this.m_allUserPermissionLabel.getText());
        this.m_allUserPermissionLabel.updateUI();
    }

    private String getAccessPermissionString(int nSecurityFlags) {
        StringBuffer sPermission = new StringBuffer(" [");
        if ((nSecurityFlags & 1) == 1) {
            sPermission.append(VWResource.QueryAccess);
        }
        if ((nSecurityFlags & 2) == 2) {
            sPermission.append(VWResource.ProcessAccess);
        }
        if ((nSecurityFlags & 4) == 4) {
            sPermission.append(VWResource.CreateAccess);
        }
        sPermission.append("]");
        return sPermission.toString();
    }

    protected static class ConfigAccessSecurity
    extends VWParticipantItem {
        protected int m_userAccessSecurity = 0;

        ConfigAccessSecurity(VWParticipant vwParticipant, int accessRight) throws VWException {
            super(vwParticipant);
            this.m_userAccessSecurity = accessRight;
        }

        public String getDisplayName() {
            String displayName = super.getDisplayName();
            if (displayName == null) {
                displayName = VWResource.Invalid;
            }
            return displayName;
        }
    }

    protected class SecurityPaneMouse
    extends MouseAdapter {
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopup(event);
            }
        }

        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopup(event);
            } else {
                Object object = event.getSource();
                if (object == VWConfigSecurityPane.this.m_availableList) {
                    if (!VWConfigSecurityPane.this.m_selectedList.isSelectionEmpty()) {
                        VWConfigSecurityPane.this.m_selectedList.clearSelection();
                    }
                } else if (object == VWConfigSecurityPane.this.m_selectedList && !VWConfigSecurityPane.this.m_availableList.isSelectionEmpty()) {
                    VWConfigSecurityPane.this.m_availableList.clearSelection();
                }
            }
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                Object object = event.getSource();
                if (object == VWConfigSecurityPane.this.m_selectedList && VWConfigSecurityPane.this.m_removeButton.isEnabled()) {
                    VWConfigSecurityPane.this.removeSelectedItems();
                } else if (object.equals(VWConfigSecurityPane.this.m_availableList) && VWConfigSecurityPane.this.m_addButton.isEnabled()) {
                    VWConfigSecurityPane.this.addSelectedItems();
                }
            }
        }

        private void showPopup(MouseEvent event) {
            ConfigAccessSecurity sItem;
            int[] selectedIndices;
            if (event.getSource() == VWConfigSecurityPane.this.m_selectedList && (selectedIndices = VWConfigSecurityPane.this.m_selectedList.getSelectedIndices()).length > 0 && (sItem = (ConfigAccessSecurity)VWConfigSecurityPane.this.m_selectedList.getSelectedValue()).getType() != 3) {
                Point pt = event.getPoint();
                VWConfigSecurityPane.this.m_accessRightMenu.show(VWConfigSecurityPane.this.m_selectedList, pt.x, pt.y);
            }
        }
    }

    protected class SecurityListCellRenderer
    extends VWParticipantLabel
    implements ListCellRenderer {
        protected SecurityListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setComponentOrientation(list.getComponentOrientation());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (cellHasFocus) {
                    this.setBorder(new LineBorder(SystemColor.windowBorder));
                } else {
                    this.setBorder(new LineBorder(list.getBackground()));
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                this.setBorder(new LineBorder(list.getBackground()));
            }
            if (value == null) {
                this.setIcon(null);
                this.setText(null);
                this.setToolTipText(null);
            } else if (value instanceof ConfigAccessSecurity) {
                ConfigAccessSecurity aEle = (ConfigAccessSecurity)value;
                if (aEle.m_userAccessSecurity == 0) {
                    this.setText(aEle.getDisplayName());
                } else if (aEle.m_userAccessSecurity == 16) {
                    this.setText(aEle.getDisplayName() + " [" + VWResource.InvalidUserGroup + "]");
                } else {
                    this.setText(aEle.getDisplayName() + VWConfigSecurityPane.this.getAccessPermissionString(aEle.m_userAccessSecurity));
                }
                if (aEle.m_userAccessSecurity == 16) {
                    this.setIcon(ICON_INVALID);
                } else if (aEle.getType() == 1) {
                    this.setIcon(ICON_GROUP);
                } else if (aEle.getType() == 0) {
                    this.setIcon(ICON_USER);
                } else {
                    this.setIcon(ICON_INVALID);
                }
                this.setVWParticipant(aEle.getVWParticipant());
            }
            return this;
        }
    }
}

